VERSION 5.00
Object = "{4DE9E2A3-150F-11CF-8FBF-444553540000}#4.0#0"; "DLXOCX32.OCX"
Begin VB.Form Form1 
   Caption         =   "Form1"
   ClientHeight    =   4965
   ClientLeft      =   2355
   ClientTop       =   1740
   ClientWidth     =   6750
   ControlBox      =   0   'False
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   4965
   ScaleWidth      =   6750
   Begin VB.Frame Frame1 
      Caption         =   "Port B, Bit Control"
      Enabled         =   0   'False
      Height          =   855
      Left            =   840
      TabIndex        =   8
      Top             =   3600
      Width           =   2535
      Begin VB.CheckBox chkPortB 
         Height          =   195
         Index           =   7
         Left            =   360
         TabIndex        =   16
         Top             =   360
         Width           =   255
      End
      Begin VB.CheckBox chkPortB 
         Height          =   195
         Index           =   6
         Left            =   600
         TabIndex        =   15
         Top             =   360
         Width           =   255
      End
      Begin VB.CheckBox chkPortB 
         Height          =   195
         Index           =   5
         Left            =   840
         TabIndex        =   14
         Top             =   360
         Width           =   255
      End
      Begin VB.CheckBox chkPortB 
         Height          =   195
         Index           =   4
         Left            =   1080
         TabIndex        =   13
         Top             =   360
         Width           =   255
      End
      Begin VB.CheckBox chkPortB 
         Height          =   195
         Index           =   3
         Left            =   1320
         TabIndex        =   12
         Top             =   360
         Width           =   255
      End
      Begin VB.CheckBox chkPortB 
         Height          =   195
         Index           =   2
         Left            =   1560
         TabIndex        =   11
         Top             =   360
         Width           =   255
      End
      Begin VB.CheckBox chkPortB 
         Height          =   195
         Index           =   1
         Left            =   1800
         TabIndex        =   10
         Top             =   360
         Width           =   255
      End
      Begin VB.CheckBox chkPortB 
         Height          =   195
         Index           =   0
         Left            =   2040
         TabIndex        =   9
         Top             =   360
         Width           =   255
      End
      Begin VB.Label Label3 
         Caption         =   "bit 7"
         BeginProperty Font 
            Name            =   "Small Fonts"
            Size            =   6
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   135
         Left            =   240
         TabIndex        =   18
         Top             =   600
         Width           =   375
      End
      Begin VB.Label Label2 
         Caption         =   "bit 0"
         BeginProperty Font 
            Name            =   "Small Fonts"
            Size            =   6
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   135
         Left            =   2040
         TabIndex        =   17
         Top             =   600
         Width           =   375
      End
   End
   Begin VB.CommandButton cmdConfigB 
      Caption         =   "Configure Port B for Output"
      Enabled         =   0   'False
      Height          =   375
      Left            =   840
      TabIndex        =   7
      Top             =   2280
      Width           =   2655
   End
   Begin VB.CommandButton cmdExit 
      Caption         =   "Exit"
      Height          =   495
      Left            =   5160
      TabIndex        =   6
      Top             =   3960
      Width           =   975
   End
   Begin VB.ComboBox devNum 
      Height          =   315
      Left            =   3720
      TabIndex        =   4
      TabStop         =   0   'False
      Text            =   "0"
      Top             =   840
      Width           =   735
   End
   Begin VB.CommandButton cmdInit 
      Caption         =   "Init the LDD"
      Height          =   375
      Left            =   840
      TabIndex        =   2
      Top             =   840
      Width           =   2655
   End
   Begin DlsrLib.DriverLINXLDD DriverLINXLDD1 
      Left            =   4560
      Top             =   2040
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin VB.Label Label1 
      Caption         =   "DriverLINX Device Number: "
      BeginProperty Font 
         Name            =   "Small Fonts"
         Size            =   6
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   135
      Left            =   3600
      TabIndex        =   5
      Top             =   480
      Width           =   2055
   End
   Begin VB.Label Label4 
      AutoSize        =   -1  'True
      BackColor       =   &H000000FF&
      Caption         =   "  KEITHLEY  "
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   13.5
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00FFFFFF&
      Height          =   360
      Left            =   360
      TabIndex        =   3
      Top             =   240
      Width           =   1650
   End
   Begin VB.Label lblStatus 
      BackColor       =   &H8000000E&
      Caption         =   "Status"
      Height          =   375
      Left            =   840
      TabIndex        =   1
      Top             =   2880
      Width           =   5295
   End
   Begin VB.Label lblBaseAddr 
      BackColor       =   &H8000000E&
      Caption         =   "Base Address of card"
      Height          =   375
      Left            =   840
      TabIndex        =   0
      Top             =   1440
      Width           =   4575
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'  This example was tested in Win98SE with an ERA-01 and
'  KPCMCIA-PIO24-C using two drivers:
'  1.  DriverLINX version KPCMCIA-850A04 and
'  2.  the DLPortIO driver, a generic Port I/O driver
'  that gives access to the registers of the KPCMCIA card
'
'  An external power supply for the ERA-01 is required when used with
'  KPCMCIA-PIO24-C
'
' This example uses the LDD object of the DriverLINX driver
' to read out the baseaddress of the card.
'
' The DlPortWritePortUchar function of the DLPortIO driver
' is then used to access the register of Port B
'
'  The DLPortIO driver is a free download from either the Keithley
'  web site or from www.sstnet.com web site (the authors).
'
'  The DriverLINX implementation for the KPCMCIA-PIO24 does not
'  provide a means to configure the Ports for output mode from your
'  code.  It can be done only ahead of time in the DriverLINX Config
'  Panel (see web site FAQ on this procedure).
'
'  However, the card has no prohibitions for configuration from code.  It
'  just was not put into the driver for some reason.  Using the DLPortIO
'  driver to acces the card, this example configures
'  Port B for output and then allows you to set/clear the individual bits
'  which control the relays of the ERA-01
'
Option Explicit
Dim baseaddr As Integer

Private Sub chkPortB_Click(Index As Integer)
' one of the bits was clicked, update the value at Port B
Dim bitValue As Integer
Dim i As Integer
For i = 0 To 7
bitValue = bitValue + chkPortB(i).Value * 2 ^ i
Next i
' shift the on or off check box value by 2^i get the proper value for the high
' order bits
DlPortWritePortUchar baseaddr + 1, bitValue  ' write to Port B
End Sub

Private Sub cmdConfigB_Click()
' write a 0 to all bits to make them outputs; this enables the output driver
DlPortWritePortUchar baseaddr + 1, 0
Frame1.Enabled = True
cmdConfigB.Enabled = False
End Sub

Private Sub cmdExit_Click()
' turn all relays off
DlPortWritePortUchar baseaddr + 1, 0
'unload the LDD object
DriverLINXLDD1.Req_DLL_name = ""
End
End Sub

Private Sub cmdInit_Click()
On Error GoTo badDevice
With DriverLINXLDD1
.Req_DLL_name = "KPCPIO"
.device = devNum.ListIndex
.Refresh
End With
' if still here in the code, then no error
baseaddr = DriverLINXLDD1.Dev_IOaddr
lblBaseAddr.Caption = " Base Address of the KPCMCIA-PIO24 is (HEX): " & Str(Hex(baseaddr)) 'display in HEX
Form1.Caption = "Register Level Control of " & DriverLINXLDD1.Dev_Model
cmdInit.Enabled = False
cmdConfigB.Enabled = True
Form1.SetFocus
Exit Sub
badDevice:
MsgBox "Could not load driver.  Please verify the Selected Device Number.", vbCritical
End Sub

Private Sub Form_Load()
Dim i As Integer
For i = 0 To 5
devNum.AddItem Str(i), i
Next i
devNum.ListIndex = 0
End Sub

'
' the digital lines have internal pull up resistors so as inputs
' they will report as logic 1 unless pulled low.
'
' write a value of 0 to the bit to turn the output driver ON, and the
' value of the output will go to zero.
'
' write a value of 1, turns the driver off, but the pull up will pull
' the logic value to a 1.
'
